import 'package:photogram_admin_cp/import/data.dart';
import 'package:rad/rad.dart';

abstract class AuthEvent {
  final BuildContext context;

  AuthEvent(this.context);
}

class AuthEventLogout extends AuthEvent {
  AuthEventLogout(BuildContext context) : super(context);
}

class AuthEventGetSession extends AuthEvent {
  AuthEventGetSession(BuildContext context) : super(context);
}

class AuthEventLoginFromUsernameAndPassword extends AuthEvent {
  final String username;
  final String password;

  AuthEventLoginFromUsernameAndPassword(
    BuildContext context, {
    required this.username,
    required this.password,
  }) : super(context);
}

class AuthEventPreparing extends AuthEvent {
  final AdminModel authedAdmin;

  AuthEventPreparing(BuildContext context, {required this.authedAdmin}) : super(context);
}

class AuthEventSetAuthedAdmin extends AuthEvent {
  final AdminModel authedAdmin;

  AuthEventSetAuthedAdmin(BuildContext context, {required this.authedAdmin}) : super(context);
}
